/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef Dialog_H
#include "Dialog.h"
#endif
#ifndef MetviewUI_H
#include "MetviewUI.h"
#endif

#include "XMLabel.h"

template<class T,class U>
Dialog<T,U>::Dialog()
{
	U::create(MetviewUI::root());	
}

template<class T,class U>
void Dialog<T,U>::helpCB( Widget, XtPointer )
{
}

template<class T,class U>
void Dialog<T,U>::cancelCB( Widget, XtPointer )
{
	ok_   = false;
	stop_ = true;
}

template<class T,class U>
void Dialog<T,U>::okCB( Widget, XtPointer )
{
	ok_  = true;
	stop_ = true;
}


template<class T,class U>
bool Dialog<T,U>::modal(const char* message,bool def_ok)
{

	XtVaSetValues(this->form_,
		XmNdefaultButtonType,
		(def_ok? XmDIALOG_OK_BUTTON : XmDIALOG_CANCEL_BUTTON),
		0);

	if(message)
		XMLabel(this->label_).set(message);

	XtManageChild(this->form_);

	stop_ = false;

	XEvent  event_node;
	XtAppContext ac = XtWidgetToApplicationContext(this->form_);

	while(!stop_)
	{
		XtAppNextEvent(ac,&event_node);
		XtDispatchEvent(&event_node);
	}

	XtUnmanageChild(this->form_);
	
	return ok_;
}

template<class T,class U>
void Dialog<T,U>::show()
{

	XtManageChild(this->form_);
}
